# Базы данных и SQL запросы

Дан софт, автоматизирующий работу библиотеки. 3НФ схемы БД софта выглядит следующим образом:

### Произведение
- id
- название

### Издание
- id
- id_произведения
- год издания
- кол-во страниц

### Экземпляр
- id
- id_издание
- инвентаризационный номер

### Лог операций
- id
- id_user
- id_экземпляр
- дата_взяли
- дата_вернули

Нужно написать SQL-скрипты, которые отвечают на следующие вопросы:

1. Найти произведения, которые издавались более 5 раз.
2. Проверить, есть ли экземпляры, не привязанные ни к одному изданию.
3. Для каждого пользователя найти последние три взятые им произведения. Для каждого такого произведения указать, сколько всего раз его брали (за все время).
4. Список самых неблагонадежных пользователей библиотеки — рейтинг 10 самых плохих пользователей по двум или более критериям. Критерии неблагонадежности с точки зрения бизнеса предложите самостоятельно.

### Дополнительные комментарии:
1. При оценке результата учитывается оптимальность выборок данных и возвращаемых результатов.
2. Если задачу можно решить без вложенного запроса, то решение с вложенным запросом не оптимально. Секция `WITH` — это тоже вложенный запрос.
3. Считаем, что доступны все возможности языка SQL, определенные в стандартах ANSI SQL и Hive QL ([Hive Language Manual](https://cwiki.apache.org/confluence/display/Hive/LanguageManual)).

---

# Оценка критериев объявлений

У вас есть сайт — доска объявлений (например, циан, авито, алиэкспресс и др. не нужно привязываться к функционалу конкретного сайта.)

Задание: Предложить набор показателей, оценивающих качество базы объявлений.

# Оценка рекламных каналов

В течение двух недель маркетологи проводили эксперименты по двум разным рекламным площадкам (например, Google и Яндекс). На обоих ресурсах реклама была показана примерно одинаковое число раз.

Какие показатели нужно измерить, чтобы сравнить эти две площадки? Маркетологи хотят оставить одну площадку. Какие будут ваши рекомендации по выбору?

Комментарий: Рекомендации — это не просто перечень показателей, а рекомендации по их интерпретации и принятию решения на их основе.

# Дашборд анализ заказов

Есть файл с выгрузкой по истории заказов интернет-магазина (Тестовый набор данных (Заказы).xlsx).

Нужно:
1. Проанализировать файл и предложить метрики, полезные для менеджера.
2. Реализовать прототип дашборда с этими метриками и данными файла. Прототип нужно реализовать в виде приложения в Tableau Public. Скачать можно[тут](https://public.tableau.com/en-us/s/). Прислать ссылку на финальный дашборд в облаке Tableau.
3. Описать сценарий работы менеджера с этим дашбордом.
